<%@ Page Language="C#" MasterPageFile="~/MasterPage.master" AutoEventWireup="true" EnableSessionState="True" Theme="Voxco"
    Trace="false" Async="true" Inherits="Voxco.Reporting.QPrintProjects" 
    Title="<%$ Resources:Resource, VoxcoReporting%>" Codebehind="QPrintProjects.aspx.cs" %>
    
<%@ Register Src="~/WaitingPanel.ascx" TagPrefix="VxRpt" TagName="WaitingPanel" %>

<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="radI" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="radT" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="radspl" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="radG" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="radA" %>

<asp:Content ID="Content1" ContentPlaceHolderID="MainContent" Runat="Server">
    <script type="text/javascript" src="../js/jquery-1.3.2.min.js"></script>    
    <script type="text/javascript" src="../js/JScript.js"></script>   
    <script type="text/javascript">
        function FindProject(projectId)
        {
            var tree = $find('<%= GroupTreeView.ClientID %>');
			    var _nodes = tree.get_selectedNode();
				if( _nodes != null )
				{
					_nodes.unselect();
				}
				var node = tree.findNodeByValue('O:'+projectId.toString());
				if (node != null)
				{		
					var nodeP = node.get_parent();
					
					while(nodeP != null )
					{
						if(nodeP.expand)
						{
							nodeP.expand();
						}
						nodeP = nodeP.get_parent();							
					}
					node.select();
					node.expand();
				}
        }
        
        function UpdateReportRequest()
        {
            window["<%= MainAjaxManager.ClientID %>"].AjaxRequest("UpdateReportRequest");
        }
         function selectProject_OnClick()
        {
            //debugger;
            var tree = window["<%= GroupTreeView.ClientID %>"];

            window["<%= PageAjaxPanel.ClientID %>"].AjaxRequest( "ProjectTreeSelection|" + tree.SelectedNode.Value + "|" + tree.SelectedNode.Text);

            return false;
        }
   </script>
    
    <radA:RadAjaxManager ID="MainAjaxManager" runat="server" OnAjaxRequest="MainAjaxManager_OnAjaxRequest" EnableAJAX="true">
    </radA:RadAjaxManager>
    
    <asp:ObjectDataSource ID="ProjectDataSource" runat="server" SelectMethod="GetAll" TypeName="Voxco.Reporting.DataSource.Projects">
    </asp:ObjectDataSource>
    <asp:ObjectDataSource ID="GroupedProjectsDataSource" runat="server" SelectMethod="GetGroupedProjectsWithModules"
        TypeName="Voxco.Reporting.DataSource.Projects"></asp:ObjectDataSource>
    <asp:ObjectDataSource ID="QuestionsDataSource" runat="server" SelectMethod="Get" TypeName="Voxco.Reporting.DataSource.QuestionsDS" />
    
    <radA:RadAjaxLoadingPanel ID="MainAjaxLoadingPanel" runat="server" >
        <VxRpt:WaitingPanel id="WaitingPanel" runat="server" />
    </radA:RadAjaxLoadingPanel>
    <radA:RadAjaxPanel ID="PageAjaxPanel" runat="server" EnableAJAX="true" Width="100%" LoadingPanelID="MainAjaxLoadingPanel" OnAjaxRequest="PageAjaxPanel_OnAjaxRequest">
    <radspl:RadSplitter ID="ProjectSplitter" Width="100%" Height="485px" runat="server">
        <radspl:RadPane ID="ProjectSelectionPane" Width="300px" runat="server">
            <table>
                <tr>
                <td align="left" valign="top" style="width:300px" >
                    <radT:RadTreeView 
                        ID="GroupTreeView" 
                        runat="server"
                        DataSourceID="GroupedProjectsDataSource"  
                        DataFieldID="NodeId" 
                        DataFieldParentID="ParentNodeId" 
                        DataTextField="NodeLabel" 
                        DataValueField="NodeId"                       
                        OnDataBound="GroupTreeView_DataBound"                         
                        OnNodeDataBound="GroupTreeView_NodeBound"                        
                        OnClientNodeClicked="selectProject_OnClick"                        
                        EnableViewState="false" >
                    </radT:RadTreeView>
                </td>
                </tr>
                </table>
                </radspl:RadPane>
                <radspl:RadSplitBar ID="split" runat="server" />
                <radspl:RadPane ID="QuestionsPane" Width="100%" runat="server">
                <table>
                <tr>
                <td valign="top">
                    <asp:Panel ID="panQuestionsOptions" runat="server" GroupingText="<%$ Resources:Resource, QuestionSelection %>" Width="200px" Height="33%">
                        <asp:RadioButtonList ID="optQuestions" runat="server" AutoPostBack="True" CellPadding="0" CellSpacing="10" OnSelectedIndexChanged="optQuestions_SelectedIndexChanged">
                            <asp:ListItem Selected="True" Text="<%$ Resources:Resource, QuestionAll %>" Value="All"></asp:ListItem>
                            <asp:ListItem Text="<%$ Resources:Resource, QuestionList %>" Value="List"></asp:ListItem>
                            <asp:ListItem Value="Logical" Text="<%$ Resources:Resource, QuestionLogical %>"></asp:ListItem>
                        </asp:RadioButtonList>
                    </asp:Panel>
                </td>
                <td valign="top">
                    <asp:Panel ID="Panel2" runat="server" Height="370px" Width="220px" GroupingText="Questions">
                        <radG:RadGrid ID="grdQuestions" runat="server" GridLines="None" 
                          AllowMultiRowSelection="True" Height="300px" Width="200px" AutoGenerateColumns="False" Skin="Default" 
                          DataSourceID="QuestionsDataSource" EnableViewState="true" OnPageIndexChanged="grdQuestions_OnSelectedIndexChanged">
                            <MasterTableView GroupLoadMode="Client" DataSourceID="QuestionsDataSource" 
                             PageSize="10" AllowPaging="true" PagerStyle-Position="Bottom" PagerStyle-Mode="NumericPages" EnableColumnsViewState="true" 
                             EnableViewState="true" runat="server" OnDataBound="grdQuestions_OnDataBound">
                                <ExpandCollapseColumn Visible="False">
                                    <HeaderStyle Width="19px" />
                                </ExpandCollapseColumn>
                                <RowIndicatorColumn Visible="False">
                                    <HeaderStyle Width="20px" />
                                </RowIndicatorColumn>
                                <Columns>
                                    <radG:GridClientSelectColumn UniqueName="Selected">
                                        <HeaderStyle Width="25px" />
                                    </radG:GridClientSelectColumn>
                                    <radG:GridBoundColumn DataField="Alias" HeaderText="Question" UniqueName="QuestionAlias">
                                    </radG:GridBoundColumn>
                                </Columns>
                            </MasterTableView>
                            <ClientSettings AllowGroupExpandCollapse="True">
                                <Selecting AllowRowSelect="True" />
                                <Scrolling AllowScroll="True" UseStaticHeaders="True" />
                            </ClientSettings>
                            <ItemStyle Height="15px" Width="100%" />
                            <SelectedItemStyle Width="100%" />
                            <HeaderStyle Width="100%" Wrap="True" />
                            <PagerStyle AlwaysVisible="True" BorderColor="Black" BorderStyle="Solid" BorderWidth="1px"
                                PageButtonCount="50" />
                        </radG:RadGrid>
                    </asp:Panel>
                </td>
                </tr>
            </table>
        </radspl:RadPane>
    </radspl:RadSplitter>
    </radA:RadAjaxPanel>

</asp:Content>

